﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Net;
using System.Xml;

public partial class Admin_NeiRong_DaiRuTuPian : System.Web.UI.Page
{
    private 访问 访问;
    protected String 信息内容;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("导入图片", "网站后台", "导入图片", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            保存();
        else
            初始化();
    }

    private void 保存()
    {
        if (SuoShuFenLei.SelectedValue == "" || SuoShuFenLei.SelectedValue == null)
            throw new Exception("请先选择图片分类");

        DirectoryInfo[] DIS = new DirectoryInfo(Server.MapPath("~/Temp")).GetDirectories();
        for (int i = 0; i < DIS.Length; i++)
            保存图片(DIS[i]);

        访问统计_管理记录 记录 = new 访问统计_管理记录(this.Context, 访问.连接);
        记录.记录("导入图片", 访问.用户["昵称"].ToString());
    }

    private void 保存图片(DirectoryInfo DI)
    {
        访问.验证权限("13");
        int ZGID=常用.SQL_最高ID(访问.连接,程序.数据表前缀+"内容_图片_图片");
        String 标题 = DI.Name;
        String 文件资源 = 保存图片(ZGID, DI,ZengJiaShuiYin.Checked);
        int 所属栏目 = Convert.ToInt32(SuoShuFenLei.SelectedValue);
        String 标题样式_颜色 = BianTiYangShi_YanSe.Text;
        bool 标题样式_粗体 = BiaoTiYangShi_ChuTi.Checked;
        bool 标题样式_斜体 = BiaoTiYangShi_XieTi.Checked;
        bool 标题样式_删除线 = BiaoTiYangShi_ShanChuXian.Checked;
        DateTime 发布时间 = Convert.ToDateTime(FaBuShiJian.Text);
        bool 是否推荐 = ShiFouTuiJian.Checked;
        bool 图片增加水印 = ZengJiaShuiYin.Checked;
        bool 关闭评论 = GuanBiPingLun.Checked;
        int 一页显示图片数 = Convert.ToInt32(YiYeXianShiTuPianShu.Text);
        int 内容模板 = Convert.ToInt32(NeiRongMoBan.SelectedValue);
        int 内容模板_3G = Convert.ToInt32(NeiRongMoBan_3G.SelectedValue);
        int 评论模板 = Convert.ToInt32(PingLunMoBan.SelectedValue);
        int 评论模板_3G = Convert.ToInt32(PingLunMoBan_3G.SelectedValue);
        bool 权限_仅限会员 = QuanXian_JinXianHuiYuan.Checked;
        int 权限_需要等级 = Convert.ToInt32(QuanXian_XuYaoDenJi.Text);
        int 权限_扣除积分 = Convert.ToInt32(QuanXian_KouChuJiFen.Text);

        SqlCommand 语句 = new SqlCommand("INSERT INTO ["+程序.数据表前缀+"内容_图片_图片]([ID],[所属栏目],[标题],[标题样式_粗体],[标题样式_斜体],[标题样式_删除线],[标题样式_颜色],[是否推荐],[是否审核],[是否删除],[外部链接],[发布时间],[一页显示图片数],[是否关闭评论],[内容模板],[3G内容模板],[评论模板],[3G评论模板],[权限_仅限会员],[权限_需要等级],[权限_扣除积分],[文件资源])" +
            "VALUES(@ID,@所属栏目,@标题,@标题样式_粗体,@标题样式_斜体,@标题样式_删除线,@标题样式_颜色,@是否推荐,@是否审核,@是否删除,@外部链接,@发布时间,@一页显示图片数,@是否关闭评论,@内容模板,@3G内容模板,@评论模板,@3G评论模板,@权限_仅限会员,@权限_需要等级,@权限_扣除积分,@文件资源)", 访问.连接);
        语句.Parameters.Add("@ID", SqlDbType.Int).Value = ZGID;
        语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = 所属栏目;
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        语句.Parameters.Add("@标题样式_粗体", SqlDbType.Bit).Value = 标题样式_粗体;
        语句.Parameters.Add("@标题样式_斜体", SqlDbType.Bit).Value = 标题样式_斜体;
        语句.Parameters.Add("@标题样式_删除线", SqlDbType.Bit).Value = 标题样式_删除线;
        语句.Parameters.Add("@标题样式_颜色", SqlDbType.NVarChar).Value = 标题样式_颜色;
        语句.Parameters.Add("@是否推荐", SqlDbType.Bit).Value = 是否推荐;
        语句.Parameters.Add("@是否审核", SqlDbType.Bit).Value = 访问.是否包含权限("46") ? false : true;
        语句.Parameters.Add("@是否删除", SqlDbType.Bit).Value = false;
        语句.Parameters.Add("@外部链接", SqlDbType.NVarChar).Value = "";
        语句.Parameters.Add("@发布时间", SqlDbType.DateTime).Value = 发布时间;
        语句.Parameters.Add("@一页显示图片数", SqlDbType.Int).Value = 一页显示图片数;
        语句.Parameters.Add("@是否关闭评论", SqlDbType.Bit).Value = 关闭评论;
        语句.Parameters.Add("@内容模板", SqlDbType.Int).Value = 内容模板;
        语句.Parameters.Add("@3G内容模板", SqlDbType.Int).Value = 内容模板_3G;
        语句.Parameters.Add("@评论模板", SqlDbType.Int).Value = 评论模板;
        语句.Parameters.Add("@3G评论模板", SqlDbType.Int).Value = 评论模板_3G;
        语句.Parameters.Add("@权限_仅限会员", SqlDbType.Bit).Value = 权限_仅限会员;
        语句.Parameters.Add("@权限_需要等级", SqlDbType.Int).Value = 权限_需要等级;
        语句.Parameters.Add("@权限_扣除积分", SqlDbType.Int).Value = 权限_扣除积分;
        语句.Parameters.Add("@文件资源", SqlDbType.NVarChar).Value = 文件资源;
        语句.ExecuteNonQuery();

        信息内容 += Server.HtmlEncode(DI.Name) + "导入成功<br/>";

        常用.删除文件夹(DI);
    }

    private String 保存图片(int ZGID,DirectoryInfo DI,bool 是否增加水印)
    {
        String 返回值 = "";

        String 存储文件夹 = 程序.安装位置 + "Data/DT_TuPian/IMG_" + (ZGID /500) + "/";
        if (!Directory.Exists(Server.MapPath(存储文件夹)))
            Directory.CreateDirectory(Server.MapPath(存储文件夹));
        String 数据存储文件夹 = 程序.安装位置 + "Data/DT_TuPian/" + (ZGID /500) + "/";
        if (!Directory.Exists(Server.MapPath(数据存储文件夹)))
            Directory.CreateDirectory(Server.MapPath(数据存储文件夹));

        设置 图片数据 = new 设置("");

        FileInfo[] FIS = DI.GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            FileInfo FI=FIS[i];
            String 文件名="T"+ZGID+常用.随机字符(30);
            String 后缀=FI.Extension.Substring(1);
            if (!常用.是否允许后缀("gif,jpg,jpe,jpeg,png,tif,tiff,bmp", 后缀))
                continue;

            FI.MoveTo(Server.MapPath(存储文件夹 + 文件名 + "." + 后缀));
            if (是否增加水印)
                new 水印().增加水印(Server.MapPath(存储文件夹 + 文件名 + "." + 后缀));

            返回值 += 返回值 == "" ? "" : ",";
            返回值 += 存储文件夹 + 文件名 + "." + 后缀;
            图片数据[i] = Server.HtmlEncode(存储文件夹 + 文件名 + "." + 后缀) + "\"" + "";
        }

        File.WriteAllText(Server.MapPath(数据存储文件夹 + ZGID + ".xml"), 图片数据.生成XML());

        return 返回值;
    }

    private void 初始化()
    {
        DataSet 数据 = new DataSet();


        SqlCommand 语句 = new SqlCommand("SELECT [ID],[栏目名称],[所属栏目],[是否拥有子栏目] FROM ["+程序.数据表前缀+"内容_栏目] WHERE [栏目类型]='图片'", 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        生成列表(数据, 0, 1);

        FaBuShiJian.Text = DateTime.Now.ToString();

        NeiRongMoBan.Items.Add(new ListItem("默认模板", "0"));
        NeiRongMoBan_3G.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan_3G.Items.Add(new ListItem("默认模板", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/Content/")).GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            String _内容类型 = "";
            bool 是否WAP = true;

            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());
            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "内容类型")
                            _内容类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));
            读取.Close();

            if(_内容类型=="图片")
                switch (模板类型)
                {
                    case "查看内容":
                        if (是否WAP)
                            NeiRongMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            NeiRongMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                    case "评论列表":
                        if (是否WAP)
                            PingLunMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            PingLunMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                }
        }
    }

    private void 生成列表(DataSet 数据, int 父栏目, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属栏目"]) == 父栏目)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["栏目名称"]), Convert.ToString(行["ID"]));
                列表项.Attributes["style"] = Convert.ToBoolean(行["是否拥有子栏目"]) ? "" : "background:#eeeeee";
                SuoShuFenLei.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }
}
